//
//  MCDNDManager.h
//  MCApplication
//
//  Created by Michael Clark on 09/08/04.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@protocol MCDNDProcessor;

@interface MCDNDManager : NSObject {

	NSMutableDictionary*          _processors;
	NSMutableDictionary*          _objectDragTypes;
	NSMutableDictionary*          _specialConfigs;
	
	// Special processor used for when dragging objects of mixed types
	id <MCDNDProcessor>           _mixedObjectProcessor;
}

+ (MCDNDManager*)defaultManager;

//// Registry Methods
// This method will get the bundle for the class, find a plist with the same name 
//   and parse it and do the right thing
//- (void)registerProcessorClassname: (NSString*)classname;

- (void)registerDNDConfigAtPath: (NSString*)path;

- (id <MCDNDProcessor>)mixedObjectProcessor;
- (void)setMixedObjectProcessor:(id <MCDNDProcessor>)aMixedObjectProcessor;

// Special configs are special because they represent config info for classnames that do not have a processor
//  registered for them - one example of the use of this is for ProxyKeyPath stuff
- (NSDictionary*)specialConfigForClassName: (NSString*)aClassName;

- (NSString*)dropTypeForLookupType: (NSString*)aType;
- (NSString*)dragTypeForLookupType: (NSString*)aType;

- (void)registerProcessor: (id)aProcessor forIdentifier: (NSString*)anIdentifier;
- (id)processorForIdentifier: (NSString*)anIdentifier;

- (NSArray*)dropTypesForClassName: (NSString*)aClassName;
// Returns the union of all applicable drop types for the given classnames
- (NSArray*)dropTypesForClassNames: (NSArray*)classNames;

- (NSArray*)dropTypesForClassName: (NSString*)aClassName subsetIdentifier: (NSString*)anIdentifier;

- (NSArray *)allRegisteredDropTypes;

//// Dragging Methods
- (BOOL)writeObjects: (NSArray*)objects toPasteboard: (NSPasteboard*)aPasteboard subsetIdentifier: (NSString*)anIdentifier dragDelegate: (id)aDragDelegate;

- (NSDragOperation)validateDrop: (id <NSDraggingInfo>)info onTargetObject: (id)object subsetIdentifier: (NSString*)anIdentifer
				destinationView: (id)aDestination dragDelegate: (id)aDragDelegate viewOptions: (NSDictionary*)options;

- (BOOL)processDrop: (id <NSDraggingInfo>)info onTargetObject: (id)object subsetIdentifier: (NSString*)anIdentifier
	destinationView: (id)aDestination dragDelegate: (id)aDragDelegate viewOptions: (NSDictionary*)options;


@end



@interface NSObject (MCDNDManagerDragDelegate)

- (NSDragOperation)dndManager: (MCDNDManager*)dndManager validateDrop: (id <NSDraggingInfo>)info forEmptyTargetWithSubsetIdenfitier: (NSString*)anIdentifier destinationView: (id)aDestination viewOptions: (NSDictionary*)options;

- (BOOL)dndManager: (MCDNDManager*)dndManager processDrop: (id <NSDraggingInfo>)info forEmptyTargetWithSubsetIdentifier: (NSString*)anIdentifier destinationView: (id)aDestination viewOptions: (NSDictionary*)options;

@end
